var scstep, memscript, memoption;

function readscript() {
  var defaultvalue, memenv, memstyle, graphalias;
  defaultvalueenv = {
    'setRange': 'setRange(-10,10,-10,10)',
    'axis': "axis('full', 1, 1)"
  }
  textalias = {
    '[改行]': "<BR>",
    '[強調黄]': "<span class='kyochoy'>",
    '[/強調黄]': "</span>",
    '[強調赤]': "<span class='kyochor'>",
    '[/強調赤]': "</span>",
    '[強調緑]': "<span class='kyochog'>",
    '[/強調緑]': "</span>",
    '[斜体]': "<span class='italic'>",
    '[/斜体]': "</span>",
    '[下線]': "<span class='uline'>",
    '[/下線]': "</span>",
    '[上線]': "<span class='oline'>",
    '[/上線]': "</span>",
    '[取り消し線]': "<span class='torikeshi'>",
    '[/取り消し線]': "</span>",
    '[太]': "<span class='boldmozi'>",
    '[/太]': "</span>",
    '[赤]': "<span class='red'>",
    '[/赤]': "</span>",
    '[緑]': "<span class='green'>",
    '[/緑]': "</span>",
    '[青]': "<span class='blue'>",
    '[/青]': "</span>",
    '[黄]': "<span class='yellow'>",
    '[/黄]': "</span>",
    '[水]': "<span class='lightblue'>",
    '[/水]': "</span>",
    '[紫]': "<span class='purple'>",
    '[/紫]': "</span>",
    '[灰]': "<span class='gray'>",
    '[/灰]': "</span>",
    '[白]': "<span class='white'>",
    '[/白]': "</span>",
    '[大]': "<span class='big'>",
    '[/大]': "</span>",
    '[極大]': "<span class='morebig'>",
    '[/極大]': "<span class='morebig'>"
  }
  graphalias = {
    '実線': "style.strokeDasharray=0",
    '点線': "style.strokeDasharray=2",
    '破線': "style.strokeDasharray=5",
    '線色': "style.stroke",
    '線太さ': "style.strokeWidth",
    '太字': "tStyle.fontWeight='bold'",
    '細字': "tStyle.fontWeight='normal'",
    '文字サイズ': "tStyle.fontSize",
    '文字色': "tStyle.fill",
    'マーカーサイズ': "mStyle.size",
    'マーカー色': "mStyle.color",
    'マーカー内部色': "mStyle.fill", //arrow(1,1,0,0)_'red';
   "arrow\\(\\s*(.+?)\\s*,\\s*(.+?)\\s*,\\s*(.+?)\\s*,\\s*(.+?)\\s*\\)_'(\\w+)'": "【;style.strokeWidth=4;style.stroke='$5';mStyle.size=11;mStyle.color='$5';mStyle.fill='$5';line($1,$2,$3,$4,'none','warrow');】;",
     "arrow\\(\\s*(.+?)\\s*,\\s*(.+?)\\s*,\\s*(.+?)\\s*,\\s*(.+?)\\s*\\)": "【;style.strokeWidth=4;mStyle.size=11;line($1,$2,$3,$4,'none','warrow');】;",
    "_'(\\w+)'": ".style.stroke='$1'"
  }
  defaultvalue = {
    'style.fill': "style.fill='none'",
    'style.stroke': "style.stroke='black'",
    'style.strokeWidth': "style.strokeWidth=1",
    'style.strokeDasharray': "style.strokeDasharray=0",
    'mStyle.size': "mStyle.size=10",
    'mStyle.color': "mStyle.color='inherit'",
    'mStyle.fill': "mStyle.fill='white'",
    'tStyle.fontStyle': "tStyle.fontStyle='normal'",
    'tStyle.fontSize': "tStyle.fontSize=13",
    'tStyle.fontWeight': "tStyle.fontWeight='bold'",
    'tStyle.fill': "tStyle.fill='black'",
    'aStyle.axisStroke': "aStyle.axisStroke='black'",
    'aStyle.axisWidth': "aStyle.axisWidth=2",
    'aStyle.gridStroke': "aStyle.gridStroke='darkGray'",
    'aStyle.gridWidth': "aStyle.gridWidth=1",
    'aStyle.indexSize': "aStyle.indexSize=10"
  }
  memenv = {
    'graph1': {
      'setRange': defaultvalueenv['setRange'],
      'axis': defaultvalueenv['axis']
    },
    'graph2': {
      'setRange': defaultvalueenv['setRange'],
      'axis': defaultvalueenv['axis']
    }
  }
  memstyle = {
    'graph1': {},
    'graph2': {}
  }
  memscript = {
    'text1': [],
    'text2': [],
    'graph1': [],
    'graph2': []
  };
  memoption = {
    'text1': [],
    'text2': [],
    'graph1': [],
    'graph2': []
  };
  var step = -1;
  var tempf = {};
  var tempstr = {};
  tempf['graph1'] = 0;
  tempf['graph2'] = 0;
  var str = $('textarea[name="myscript"]').val();
  var tempscript = str.split(/\r\n|\r|\n/);
  for (var i = 0; i < tempscript.length; i++) {
    if (tempscript[i].match(/^&?\[(.+?)\](.+)/)) {
      if (tempscript[i].match(/^\[(.+?)\](.+)/)) {
        step++;
        memoption['text1'][step] = '';
        memoption['text2'][step] = '';
        memoption['graph1'][step] = '';
        memoption['graph2'][step] = '';
        if (step == 0) {
          memscript['text1'][step] = '';
          memscript['text2'][step] = '';
          memscript['graph1'][step] = '';
          memscript['graph2'][step] = '';
        }
        if (step > 0) {
          memscript['text1'][step] = memscript['text1'][step - 1];
          memscript['text2'][step] = memscript['text2'][step - 1];
          memscript['graph1'][step] = memscript['graph1'][step - 1];
          memscript['graph2'][step] = memscript['graph2'][step - 1];
        }
      } else if (step < 0) {
        alert('Scriptエラー:先頭行');
      }
      var arr = tempscript[i].match(/^&?(\[.+?\])(.+)/);
      var head = arr[1];
      var body = arr[2];
      if (head.match(/\[text\d\]/)) {
        var targettext = head.match(/\[(text\d)\]/);
        body = escape_html(body); //text の bodyをHTMLエスケープ
        for (var key in textalias) {
          body = body.replace(new RegExp(regExpEscape(key), 'g'), textalias[key]);
        }
        memscript[targettext[1]][step] = memscript[targettext[1]][step] + body;
        memoption[targettext[1]][step] = memoption[targettext[1]][step] + body;
      } else if (head.match(/\[newtext\d\]/)) {
        var targettext = head.match(/\[new(text\d)\]/);
        body = escape_html(body); //text の bodyをHTMLエスケープ
        for (var key in textalias) {
          body = body.replace(new RegExp(regExpEscape(key), 'g'), textalias[key]);
        }
        memscript[targettext[1]][step] = body;
        memoption[targettext[1]][step] = "[new]";
      } else if (head.match(/\[graph\d.*\]/)) {
        body = body.replace(/】/g, "】;");
        body = body.replace(/》/g, "》;");
        var temphead = head.match(/\[(graph\d).*\]/);
        var graph = temphead[1];
        if (head.match(/\[(graph\d).*,anim\(\s*\$\w\s*,.+?→.+?,\s*time\s*=.+?\).*\]/)) { //アニメーション（軌跡を残すのは媒介変数表示でしかできなさそう）
		var para = head.match(/\[(graph\d).*,anim\(\s*(\$\w)\s*,(.+?→.+?,\s*time\s*=.+?)\).*\]/);
          var anipara = para[3];
		  anipara = anipara.replace(/\s/g, '');  // 
          var anivalue = regExpEscape(para[2]);
          body = body.replace(new RegExp(anivalue, 'g'), "({{0}})");
          memoption[graph][step] = "[anim]," + anipara;
        }
        if (head.match(/\[(graph\d).*,\s*para\(.+?\).*\]/)) { //変数の代入
          var para = head.match(/\[(graph\d).*,\s*para\((.+?)\).*\]/);
          var parastr = para[2];
		  parastr = parastr.replace(/\s/g, '');  // 
          var temppara = parastr.split(/,/);
          for (var j = 0; j < temppara.length; j++) {
            var paravalue = temppara[j].split(/=/);
            var pkey = regExpEscape(paravalue[0]); //エスケープ文字をすべてエスケープ
            body = body.replace(new RegExp("(text.+?'[^']*?)" + pkey + "(.*?')", 'g'), "$1" + paravalue[1] + "$2");
            body = body.replace(new RegExp(pkey, 'g'), "(" + paravalue[1] + ")");
          }
        } // ************* end of head *******************
        for (var key in graphalias) {
          body = body.replace(new RegExp(key, 'g'), graphalias[key]);
        }
        var newbody = '';
        var bodyparts = body.split(/;/);
        for (var k = 0; k < bodyparts.length; k++) { //"plot(['"+ func_x + "', '" + func_y + "'], {{1}}, {{0}});"
          var repairf = 0;
          var tempbody = bodyparts[k];
          if (tempbody.match(/^\s*[《【](.*)/)) {
            var temp = tempbody.match(/^\s*[《【](.*)/);
            tempbody = temp[1];
            tempf[graph] = '1';
            tempstr[graph] = '';
          } else if (tempbody.match(/(.*)[》】]\s*$/)) {
            var temp = tempbody.match(/(.*)[》】]\s*$/);
            tempbody = temp[1];
            tempf[graph] = 0;
          }
          if (tempbody.match(/^\s*kisekiplot/)) { //kisekiplot('x=t','y=t^2')
            var kisekifunc = tempbody.match(/^\s*kisekiplot\(\s*'(.+?),(.+?)'\s*\)(.*)$/);
            newbody = newbody + "plot(['" + kisekifunc[1].replace(/\{\{0\}\}/g, "t") + "','" + kisekifunc[2].replace(/\{\{0\}\}/g, "t") + "'], {{1}}, {{0}})" + kisekifunc[3] + ";";
          } else if (tempbody.match(/^\s*clearall\s*$/)) {
            newbody = newbody + memenv[graph]['setRange'] + ';';
            repairf = 1;
          } else if (tempbody.match(/^\s*clear\s*$/)) {
            newbody = newbody + memenv[graph]['setRange'] + ';' + memenv[graph]['axis'] + ';';
            repairf = 1;
          } else {
            newbody = newbody + tempbody + ';';
            if (tempbody.match(/^\s*\w+?\.?\w+?\s*[=\(]/)) {
              var functions = tempbody.match(/^\s*(\w+?\.?\w+?)\s*[=\(]/);
              if (functions[1] == 'setRange') {
                repairf = 1;
                memenv[graph]['setRange'] = tempbody;
              } else if (functions[1] == 'axis') {
                memenv[graph]['axis'] = tempbody;
              } else if (functions[1] in defaultvalue) {
                if (tempf[graph] == 1) {
                  if (functions[1] in memstyle[graph]) {
                    tempstr[graph] = tempstr[graph] + memstyle[graph][functions[1]] + ';';
                  } else {
                    tempstr[graph] = tempstr[graph] + defaultvalue[functions[1]] + ';';
                  }
                } else {
                  memstyle[graph][functions[1]] = tempbody;
                }
              }
            }
          }
          if (bodyparts[k].match(/(.*)[》】]\s*$/)) {
            newbody = newbody + tempstr[graph] + ';';
            tempstr[graph] = '';
          }
          if (repairf == 1) {
            repairf = 0;
            tempf[graph] = 0;
            for (var key in memstyle[graph]) {
              newbody = newbody + memstyle[graph][key] + ';';
            }
          }
        }
        if (body.match(/(setRange|clear)/)) { //setRangeコマンドによって、グラフがクリアされる。
          memscript[graph][step] = newbody;
        } else {
          memscript[graph][step] = memscript[graph][step] + newbody;
        }
      }
    } // End of 『if (tempscript[step].match(/(.+?):(.+)/)){』
  }
  $('#maxstep').html(memscript['text1'].length);
  $('#nowstep').html(0);
}

function change(fb) {
  var svg1 = document.getElementById('graph1');
  var svg2 = document.getElementById('graph2');
  if (svg1.animating == true) {
    svg1.animating = false;
  }
  if (svg2.animating == true) {
    svg2.animating = false;
  }
  if (fb == 'forward') {
    scstep++;
    if (scstep == memscript['text1'].length + 1) {
      scstep = 0;
    }
  }
  if (fb == 'back') {
    if (scstep == 0) {
    //  scstep = memscript['text1'].length - 1;
    } else if (scstep > 0) {
      scstep = scstep - 1;
    }
  }
  if (scstep == memscript['text1'].length) {
    $('#text2').html('もう一度クリックすると初めから繰り返します。');
  } else {
    if(scstep==0){
      var svg = document.getElementById('graph1');
      svg.script('setRange(-10,10,-10,10);');
      svg.update();
      svg = document.getElementById('graph2');
      svg.script('setRange(-10,10,-10,10);');
      svg.update();
      $('#text1').html('');
      $('#text2').html('');
    }
    $('#nowstep').html(scstep + 1);
    puttext('text1', fb);
    puttext('text2', fb);
    drawgraph('graph1');
    drawgraph('graph2');
  }
}

function puttext(text, fb) {
  var body = memscript[text][scstep];
  var option = memoption[text][scstep];
  if (option.match(/^\[new\]/) || fb == 'back') {
    $('#' + text).html(body);
  } else {
    $('#' + text).append(option);
  }
  MathJax.Hub.Typeset($('#' + text)[0], function () {});
}

function drawgraph(graph) {
  var svg = document.getElementById(graph);
  var tempscript = memscript[graph][scstep];
  tempscript = tempscript.replace(/;;/g, ';');
  svg.script(tempscript);
  svg.update();
  if (memoption[graph][scstep].match(/\[anim\],/)) {
    var para = memoption[graph][scstep].match(/\[anim\],(.+?)→(.+?),time=(.+?)$/);
    var t_start = para[1];
    var t_end = para[2];
    var animtime = para[3];
    svg.anim([
      [t_start, t_end], t_start
    ], animtime, true); //  軌跡とアニメーション両方に対応
  }
}

function floatFormat(number, n) {
  var _pow = Math.pow(10, n);
  return Math.round(number * _pow) / _pow;
}

function omission(num, digits) {
  var pattern = new RegExp("^[-]?([1-9]\\d*|0)(\\.\\d+)?$");
  if (pattern.test(num)) { //入力された値が数値の場合 
    num = num * Math.pow(10, digits);
    if (num >= 0) {
      num = Math.floor(num);
    } else {
      num = Math.ceil(num);
    }
    var returnVal = num * Math.pow(10, -1 * digits);
    return returnVal.toFixed(digits);
  }
  return "";
}
var regExpEscape = function (str) {
  return str.replace(/[-\/\\^$*+?.()|\[\]{}]/g, '\\$&');
};

function escape_html(string) {
  if (typeof string !== 'string') {
    return string;
  }
  return string.replace(/[&'`"<>]/g, function (match) {
    return {
      '&': '&amp;',
      "'": '&#x27;',
      '`': '&#x60;',
      '"': '&quot;',
      '<': '&lt;',
      '>': '&gt;',
    }[match]
  });
}
